import { createServer } from "https";
import { createServer as localServer } from "http";
import { app } from "./appsub.js";
import cluster from "cluster";
import os from "os";
import envVars from "./Config/env-vars.js";
import colors from "colors";
import logger from "./Config/logger.js";
import { initializeSocket } from "./socket.js";
import fs from "fs";


const numCPUs = os.cpus().length;

// if (cluster.isPrimary) {
//   console.log(`Master ${process.pid} is running`);

//   // Fork workers
//   for (let i = 0; i < numCPUs; i++) {
//     cluster.fork();
//   }

//   cluster.on("exit", (worker, code, signal) => {
//     console.log(`Worker ${worker.process.pid} died`);
//   });
// } else {
let httpServer = null;
if (process.env.NODE_ENV !== "production") {
  httpServer = localServer(app);
} else {
  httpServer = createServer(
    {
      key: fs.readFileSync(process.env.SSL_KEY),
      cert: fs.readFileSync(process.env.SSL_CERT),
      ca: fs.readFileSync(process.env.SSL_CA),
    },
    app
  );
}
const port = envVars.port || 3050;
initializeSocket(httpServer);

httpServer.listen(port, async () => {
  logger.info(
    `${envVars.env.toUpperCase()} Worker ${process.pid} Listening on PORT ${envVars.port
      }`.yellow
  );
});