import Joi from "joi";

export const serviceValidator = Joi.object({
    service_title: Joi.string().required().messages({
        "string.empty": "Service title is required.",
    }),
    description: Joi.string().required().messages({
        "string.empty": "Description is required.",
    }),
    pricing_type: Joi.string()
        .valid("free", "fixed", "negotiable")
        .required()
        .messages({
            "any.only": "Pricing type must be one of: free, fixed, negotiable.",
            "string.empty": "Pricing type is required.",
        }),
    location: Joi.string().required().messages({
        "string.empty": "Location is required.",
    }),
    image: Joi.string().optional(),
    service_category: Joi.string().required().messages({
        "string.empty": "Category is required.",
    }),
    price: Joi.number().optional(),
    isRequested: Joi.boolean().optional()
});