import Joi from "joi";

export const createServiceRequestSchema = Joi.object({
    service_title: Joi.string().required(),
    description: Joi.string().required(),
    urgency_level: Joi.string().valid("low", "medium", "high").required(),
    budget: Joi.number().optional(),
    location: Joi.string().required(),
    category: Joi.string().required(),
});

export const updateServiceRequestSchema = Joi.object({
    service_title: Joi.string().optional(),
    description: Joi.string().optional(),
    urgency_level: Joi.string().valid("low", "medium", "high").optional(),
    budget: Joi.number().optional(),
    location: Joi.string().optional(),
    category: Joi.string().optional(),
});