import Joi from "joi";

export const createRatingSchema = Joi.object({
  bookingId: Joi.string().required().messages({
    "any.required": "booking Id ID is required",
    "string.empty": "bookingI d ID cannot be empty",
  }),
  rating: Joi.number().min(1).max(5).required().messages({
    "number.base": "Rating must be a number",
    "number.min": "Rating must be at least 1",
    "number.max": "Rating cannot exceed 5",
    "any.required": "Rating is required",
  }),
  review: Joi.string().allow("").optional(),
});

export const updateRatingSchema = Joi.object({
  rating: Joi.number().min(1).max(5).required().messages({
    "number.base": "Rating must be a number",
    "number.min": "Rating must be at least 1",
    "number.max": "Rating cannot exceed 5",
    "any.required": "Rating is required",
  }),
  review: Joi.string().allow("").optional(),
});