import multer from "multer";
import path from "path";
// import { dirname } from "./FilePath.js";
export const Storage = multer.diskStorage({
  destination: (req, file, callback) => {
    callback(null, path.join("Uploads"));
  },
  filename: (req, file, callback) => {
    const fileName = file.originalname.split(" ").join("-");
    const extension = path.extname(fileName);
    const uniqueSuffix = Date.now() + "-" + Math.round(Math.random() * 1e9);
    callback(null, uniqueSuffix + extension);
  },
});

export const handleMultipartData = multer({
  storage: Storage,
  limits: {
    fileSize: 1024 * 1024 * 100,
  },
  fileFilter: (req, file, callback) => {
    const FileTypes = /jpeg|jpg|png|gif|pdf|docx|doc|PNG/;
    const mimType = FileTypes.test(file.mimetype);
    const extname = FileTypes.test(path.extname(file.originalname));
    if (mimType && extname) {
      return callback(null, true);
    }
      callback(new Error("Invalid file type. Only .jpg, .jpeg, .png, .gif, .pdf, .doc, and .docx files are allowed."));
  },
});
