import express from "express";
import { AuthMiddleware } from "./Middleware/AuthMiddleware.js";
import WalletControllers from "../Controller/payment/wallet.controller.js";

const walletRouter = express.Router();

walletRouter.post("/connect-wallet", AuthMiddleware, WalletControllers.connectWallet);
walletRouter.get("/fetch-wallet", AuthMiddleware, WalletControllers.fetchWallet);
walletRouter.post("/wallet-top-up", AuthMiddleware, WalletControllers.walletTopUp);
walletRouter.post("/confirm-top-up", AuthMiddleware, WalletControllers.confirmTopUp);

export default walletRouter;