import express from "express";
import { createServiceRequest, deleteServiceRequest, getAllServiceRequests, getServiceRequestById, updateServiceRequest, updateStatus } from "../Controller/serviceRequest.controller.js";
import { AuthMiddleware } from "./Middleware/AuthMiddleware.js";


const ServiceRequestRouter = express.Router();

ServiceRequestRouter.post("/create", AuthMiddleware, createServiceRequest);
ServiceRequestRouter.get("/", getAllServiceRequests);
ServiceRequestRouter.get("/:id", getServiceRequestById);
ServiceRequestRouter.put("/:id", AuthMiddleware, updateServiceRequest);
ServiceRequestRouter.delete("/:id", AuthMiddleware, deleteServiceRequest);
ServiceRequestRouter.put("/update/status/:id", AuthMiddleware, updateStatus);

export default ServiceRequestRouter;