import express from "express";
import {
    createService,
    getServices,
    getServiceById,
    updateService,
    deleteService,
    getAllUsers,
    getSingleUser,
} from "../Controller/service.controller.js";
import { validateRequest } from "./Middleware/validate.js";
import { serviceValidator } from "../Utils/Validator/serviceValidator.js";
import { AuthMiddleware, SPMiddleware } from "./Middleware/AuthMiddleware.js";

const serviceRouter = express.Router();

serviceRouter.post("/create", AuthMiddleware, validateRequest(serviceValidator), createService);
serviceRouter.get("/all", getServices);
serviceRouter.get("/providers", getAllUsers);
serviceRouter.get("/single/:id", getServiceById);
serviceRouter.put("/update/:id", AuthMiddleware, validateRequest(serviceValidator), updateService);
serviceRouter.delete("/delete/:id", AuthMiddleware, deleteService);
serviceRouter.get("/providers-details/:id", getSingleUser);
export default serviceRouter;