import { Router } from "express";
import authRouter from "./auth.router.js";
import serviceRouter from "./service.router.js";
import ratingRouter from "./rating.router.js";
import ServiceRequestRouter from "./serviceRequest.router.js";
import adminRouter from "./admin.router.js";
import bookingRouter from "./booking.router.js";
import notificationRouter from "./notification.router.js";
import paymentRouter from "./payment.router.js";
import walletRouter from "./wallet.router.js";
import connectAccountRouter from "./connect-account.router.js";

const Routes = () => {
  const router = Router();

  router.use("/auth", authRouter);
  router.use("/service", serviceRouter)
  router.use("/rating", ratingRouter)
  router.use("/service-request", ServiceRequestRouter)
  router.use("/admin", adminRouter)
  router.use("/booking", bookingRouter)
  router.use("/notification", notificationRouter)
  router.use("/payment", paymentRouter)
  router.use("/wallet", walletRouter);
  router.use("/connect-account", connectAccountRouter);

  return router;
};
export default Routes;
