import express from "express";
import {
    createRating,
    getAllRatings,
    updateRating,
    deleteRating,
} from "../Controller/rating.controller.js";
import { AuthMiddleware } from "./Middleware/AuthMiddleware.js";

const ratingRouter = express.Router();

// Create
ratingRouter.post("/create", AuthMiddleware, createRating);

// Read All
ratingRouter.get("/", AuthMiddleware, getAllRatings);

// Update
ratingRouter.put("/update/:id", AuthMiddleware, updateRating);

// Delete
ratingRouter.delete("/update/:id", AuthMiddleware, deleteRating);

export default ratingRouter;
