import express from "express";
import { AuthMiddleware } from "./Middleware/AuthMiddleware.js";
import PaymentController from "../Controller/payment/payment.controller.js";

const paymentRouter = express.Router();

// Sent-Payment
paymentRouter.post("/sent-payment", AuthMiddleware, PaymentController.sentPayment);
paymentRouter.post("/confirm-payment", AuthMiddleware, PaymentController.confirmPayment);
paymentRouter.get("/get-all-payment", AuthMiddleware, PaymentController.getAllPayment);
paymentRouter.get("/get-transaction-history", AuthMiddleware, PaymentController.getTransactionHistory);
paymentRouter.post("/payment-with-wallet", AuthMiddleware, PaymentController.paymentWithWallet);

export default paymentRouter;