import { Router } from "express";
import { AuthMiddleware } from "./Middleware/AuthMiddleware.js";
import NotificationController from "../Controller/NotificationController.js";

const notificationRouter = Router();

// Create Notification
notificationRouter.route("/").post(AuthMiddleware, NotificationController.createNotification);

// get Notification
notificationRouter.route("/").get(AuthMiddleware, NotificationController.fetchNotificationsByUserId);

// Delete Notification
notificationRouter.route("/delete/:id").delete(NotificationController.deleteNotification);

// Update isRead status Notification
notificationRouter.route("/update-status/:id").put(AuthMiddleware, NotificationController.updateStatus);

// Mark all notifications as read
notificationRouter.route("/mark-all-as-read").put(AuthMiddleware, NotificationController.markAllAsRead);

export default notificationRouter;