import { Router } from "express";
import { AuthMiddleware } from "./Middleware/AuthMiddleware.js";
import ChatController from "../Controller/chat.controller.js";

const chatRouter = Router();

// Create a new chat
chatRouter
  .route("/create")
  .post(AuthMiddleware, ChatController.createChat);

// Get all chats (optional, depending on what `index` does)
chatRouter
  .route("/get-chat-list")
  .get(AuthMiddleware, ChatController.chatList);

// Send a message in a chat
chatRouter
  .route("/send-message")
  .post(AuthMiddleware, ChatController.sendMessage);

// Get all messages from a specific chat
chatRouter
  .route("/get-messages/:chatId")
  .get(AuthMiddleware, ChatController.getChatMessages);

// Get chat with messages
chatRouter
  .route("/chat-with-messages/:chatId")
  .get(AuthMiddleware, ChatController.chatWithMessages);

// Mark a message as seen
chatRouter
  .route("/message-seen/:messageId")
  .put(AuthMiddleware, ChatController.messageSeen);

export default chatRouter;
