import express from "express";
import { AuthMiddleware } from "./Middleware/AuthMiddleware.js";
import { createBooking, getAllBookingRequests, getAllMyBooking, updateStatus } from "../Controller/booking.controller.js";
import { getAllServiceCategory } from "../Controller/service.controller.js";

const bookingRouter = express.Router();

bookingRouter.post("/create", AuthMiddleware, createBooking);
bookingRouter.get("/my-bookings", AuthMiddleware, getAllMyBooking);
bookingRouter.get("/request", AuthMiddleware, getAllBookingRequests);
bookingRouter.post("/update-status/:bookingId", AuthMiddleware, updateStatus)
bookingRouter.get("/get-all-categories", getAllServiceCategory)

export default bookingRouter;