import express from "express";
import { approvedServiceRequest, createCategory, getAllServices, getAllUsers, toggleUserBlockStatus } from "../Controller/admin.controller.js";
// import { AdminMiddleware } from "./Middleware/AuthMiddleware.js";
import { AuthMiddleware } from "./Middleware/AuthMiddleware.js";

const adminRouter = express.Router();

// Create
adminRouter.post("/service/approved/:id", AuthMiddleware, approvedServiceRequest);
adminRouter.post("/service/create", AuthMiddleware, createCategory);
adminRouter.get("/user/get-all-users", AuthMiddleware, getAllUsers);
adminRouter.get("/service/get-all-services", AuthMiddleware, getAllServices);
adminRouter.put("/block-toggle/:id", AuthMiddleware, toggleUserBlockStatus);

export default adminRouter;