import mongoose from "mongoose";

/**
 * Ride Additional Services Schema
 * @private
 */
const WebContentSchema = mongoose.Schema(
  {
    content: { type: String, trim: true },
    type: {
      type: String,
      enum: ["privacy-policy", "terms-and-condition", "faqs", "about-us"],
    },
    created_by: {
      type: mongoose.Schema.Types.ObjectId,
      required: false,
      ref: "User",
    },
  },
  {
    timestamps: true,
  }
);

const WebContent = mongoose.model("WebContent", WebContentSchema);

/**
 * @typedef WebContent
 */
export default WebContent;
