import mongoose, { Schema, model } from "mongoose";
const serviceRequestSchema = new Schema(
    {
        service_title: { type: String, required: true },
        description: { type: String, required: true },
        urgency_level: {
            type: String,
            required: true,
            enum: ["low", "medium", "high"],
        },
        budget: {
            type: Number,
            required: false,
        },
        status: {
            type: String,
            default: "pending",
            enum: ["pending", "in_progress", "completed"],
        },
        isApproved: { type: Boolean, default: false },
        location: { type: String, required: true },
        availability: { type: String, required: true },
        category: { type: String, required: true },
        created_by: { type: mongoose.Schema.Types.ObjectId, ref: "User", },
        accepted_by: { type: mongoose.Schema.Types.ObjectId, ref: "User", }

    },
    { timestamps: true }
);

const serviceRequest = model("serviceRequest", serviceRequestSchema);
export default serviceRequest;