import mongoose, { Schema, model } from "mongoose";

const serviceSchema = new Schema(
    {
        service_title: { type: String, required: true },
        description: { type: String, required: true },
        pricing_type: {
            type: String,
            required: true,
            enum: ["free", "fixed", "negotiable"],
        },
        price: {
            type: Number,
            required: false,
        },
        location: { type: String, required: true },
        image: {
            type: mongoose.Schema.Types.ObjectId,
            ref: "fileUpload",
        },
        isApproved: {
            type: Boolean,
            default: false
        },
        service_category: {
            type: mongoose.Schema.Types.ObjectId,
            ref: "serviceCategory",
            required: true

        },
        isRequested: {
            type: Boolean,
            default: false
        },
        isDeleted: {
            type: Boolean,
            default: false
        },
        created_by: { type: mongoose.Schema.Types.ObjectId, ref: "User", },
    },
    { timestamps: true }
);

const Service = model("Service", serviceSchema);
export default Service;