import mongoose, { Schema } from "mongoose";
const ratingSchema = new Schema(
  {
    userId: { type: Schema.Types.ObjectId, ref: "User", required: true },
    receiverId: { type: Schema.Types.ObjectId, ref: "User", required: true },
    bookingId: { type: Schema.Types.ObjectId, ref: "Booking", required: true },
    rating: { type: Number, min: 1, max: 5, required: true },
    review: { type: String, trim: true },
  },
  { timestamps: true }
);
const Rating = mongoose.model("Rating", ratingSchema);
export default Rating;
