import mongoose from "mongoose";

const WalletSchema = new mongoose.Schema({
    user: { type: mongoose.Schema.Types.ObjectId, ref: "User", required: true },
    customer_id: { type: String, trim: true },
    amount: { type: Number, default: 0 },
    payment_method_id: { type: String, trim: true },
}, { timestamps: true });

const Wallet = mongoose.model("Wallet", WalletSchema);

export default Wallet;
