import mongoose from "mongoose";
import mongooseAutoPopulate from "mongoose-autopopulate";

/**
 * Payment Transactions Schema
 * @private
 */
const transactionSchema = mongoose.Schema(
  {
    payment_id: {
      type: mongoose.Schema.Types.ObjectId,
      required: false,
      ref: "Payment",
      default: null,
      autopopulate: true,
    },
    status: {
      type: String,
      enum: ["pending", "completed", "failed", "refunded"],
      required: true,
    },
    send_by: {
      type: mongoose.Schema.Types.ObjectId,
      required: false,
      ref: "User",
      default: null,
    },
    booking_id: {
      type: mongoose.Schema.Types.ObjectId,
      required: false,
      ref: "Booking",
      default: null,
    },
    received_by: {
      type: mongoose.Schema.Types.ObjectId,
      required: false,
      ref: "User",
      default: null,
    },
    stripe_tr_id: {
      type: String,
      required: false,
    },
    payment_method: {
      type: String,
      enum: ["wallet", "card",],
    },
  },
  {
    timestamps: true,
  }
);

transactionSchema.plugin(mongooseAutoPopulate);

const Transactions = new mongoose.model("Transactions", transactionSchema);

/**
 * @typedef Transactions
 */
export default Transactions;
