import mongoose from "mongoose";

/**
 * Payment Schema
 * @private
 */
const PaymentSchema = mongoose.Schema(
  {
    amount: {
      type: Number,
      required: false,
      default: 0,
    },
    currency: {
      type: String,
      required: true,
      enum: ["usd"],
      default: "usd",
    },
    payment_gateway: {
      type: String,
      enum: ["stripe"],
      default: "stripe",
    },
    payment_intent_id: {
      type: String,
      required: false,
    },
    created_by: {
      type: mongoose.Schema.Types.ObjectId,
      required: true,
      ref: "User",
    },
  },
  {
    timestamps: true,
  }
);

const Payment = new mongoose.model("Payment", PaymentSchema);
/**
 * @typedef Payment
 */
export default Payment;
