import mongoose from "mongoose";
import mongooseAutoPopulate from "mongoose-autopopulate";

/**
 * Stripe Connect Account Schema of User
 * @private
 */
const ConnectAccountSchema = mongoose.Schema(
    {
        user: {
            type: mongoose.Schema.Types.ObjectId,
            required: true,
            ref: "User",
            autopopulate: true,
        },
        connect_account_id: {
            type: String,
            required: true,
        },
    },
    {
        timestamps: true,
    }
);

ConnectAccountSchema.plugin(mongooseAutoPopulate);

const ConnectAccount = new mongoose.model("ConnectAccount", ConnectAccountSchema);

/**
 * @typedef ConnectAccount
 */
export default ConnectAccount;
