// notificationModel.js
import mongoose from "mongoose";

const notificationSchema = new mongoose.Schema(
  {
    type: {
      type: String,
    },
    title: {
      type: String,
    },
    description: {
      type: String,
    },
    link: {
      type: String,
    },
    user: {
      type: mongoose.Schema.Types.ObjectId,
      required: false,
      ref: "auth",
    },
    isRead: {
      type: Boolean,
      default: false
    }
  },
  {
    timestamps: true,
  },
);

const NotificationModel = mongoose.model("notifications", notificationSchema);
export default NotificationModel;
