import mongoose from "mongoose";
import mongooseAutoPopulate from "mongoose-autopopulate";

/**
 * Chat Schema
 * @private
 */
const ChatSchema = mongoose.Schema(
  {
    participants: [
      {
        type: mongoose.Schema.Types.ObjectId,
        ref: "User",
      },
    ],
    latestMessage: {
      type: mongoose.Schema.Types.ObjectId,
      ref: "Message",
      default: null,
    },
    chatType: {
      type: String,
      enum: ["private", "group"],
      default: "private",
    },
    radius: {
      type: Number,
      default: null
    },
    city: {
      type: String,
      default: null,
    },
    groupName: {
      type: String,
      default: "Community",
    }
  },
  {
    timestamps: true,
  }
);

ChatSchema.plugin(mongooseAutoPopulate);

const Chat = mongoose.model("Chat", ChatSchema);
export default Chat;
