import mongoose, { Schema } from "mongoose";

const bookingSchema = new Schema(
    {
        serviceId: {
            type: Schema.Types.ObjectId,
            ref: "Service",
            required: true,
        },
        status: {
            type: String,
            enum: ["pending", "in_progress", "completed", "rejected"],
            default: "pending",
        },
        userId: {
            type: Schema.Types.ObjectId,
            ref: "User",
            required: true,
        },
        accepted_by: {
            type: Schema.Types.ObjectId,
            ref: "User",
            required: true,
        },
        paymentId: {
            type: String,
            required: false,
        },
        bookingDate: {
            type: Date,
            required: true,
        },
        isPaid: {
            type: Boolean,
            default: false,
        }
    },
    {
        timestamps: true,
    }
);

const Booking = mongoose.model("Booking", bookingSchema);
export default Booking;
