import Service from "../DB/Model/service.modal.js";
import serviceRequest from "../DB/Model/serviceRequest.js";
import serviceCategory from "../DB/Model/services_category.modal.js";
import User from "../DB/Model/user.model.js";

export const approvedServiceRequest = async (req, res) => {
    try {
        const id = req.params.id;

        // 1. Check in Service model
        let service = await Service.findById(id);
        if (service) {
            service.isApproved = true;
            await service.save();
            return res.status(200).json({
                status: true,
                message: "Service approved successfully",
                data: service
            });
        }

        // let requestService = await serviceRequest.findById(id);
        // if (requestService) {
        //     requestService.isApproved = true;
        //     await requestService.save();
        //     return res.status(200).json({
        //         status: true,
        //         message: "Service request approved successfully",
        //         data: requestService
        //     });
        // }

        // 3. If not found in both, return not found
        return res.status(404).json({
            status: false,
            message: "Service not found"
        });

    } catch (error) {
        return res.status(500).json({
            status: false,
            message: "Internal server error",
            error: error.message
        });
    }
};
export const createCategory = async (req, res) => {
    try {
        const { name, description } = req.body;
        const category = new serviceCategory({ name, description });
        await category.save();
        return res.status(200).json({
            status: true,
            message: "Category created successfully",
            data: category
        });

    } catch (error) {
        return res.status(500).json({
            status: false,
            message: "Internal server error",
            error: error.message
        })
    }
}
export const getAllUsers = async (req, res) => {
    try {
        const users = await User.find().populate("image");
        if (!users)
            return res.status(404).json({
                status: false,
                message: "No users found"
            });
        return res.status(200).json({
            status: true,
            message: "Users retrieved successfully",
            data: users
        });

    } catch (error) {
        return res.status(500).json({
            status: false,
            message: "Internal server error",
            error: error.message
        })
    }
}
export const getAllServices = async (req, res) => {
    try {
        const services = await Service.find().populate("service_category");
        if (!services)
            return res.status(404).json({
                status: false,
                message: "No services found"
            });
        return res.status(200).json({
            status: true,
            message: "Services retrieved successfully",
            data: services
        });

    } catch (error) {
        return res.status(500).json({
            status: false,
            message: "Internal server error",
            error: error.message
        })
    }
}
export const toggleUserBlockStatus = async (req, res) => {
    const userId = req.params.id;
    try {
        const user = await User.findById(userId);
        if (!user)
            return res.status(404).json({
                status: false,
                message: "User not found"
            });
        user.block_status = !user.block_status;
        await user.save();
        return res.status(200).json({
            status: true,
            message: "User block status updated successfully",
            data: user
        });
    } catch (error) {
        return res.status(500).json({
            status: false,
            message: "Internal server error",
            error: error.message
        })
    }
}